#include "Button.h"

#ifdef __APPLE__
#include <OpenGL/gl.h>
#else
#include <GL/gl.h>
#endif

#include "Utilities.h"

#define BUTTON_HEIGHT 16

Button Button_create(char * inLabel, int inPositionX, int inPositionY, int inWidth) {
	Button self;
	
	self.label = inLabel;
	self.positionX = inPositionX;
	self.positionY = inPositionY;
	self.width = inWidth;
	
	return self;
}

bool Button_hitTest(Button * self, int x, int y) {
	return (x >= self->positionX && x <= (self->positionX + self->width) &&
	        y >= self->positionY && y <= (self->positionY + BUTTON_HEIGHT));
}

void Button_draw(Button * self, bool selected) {
	GLint viewport[4];
	
	glPushMatrix();
	glTranslatef(self->positionX, self->positionY, 0.0f);
	
	if (selected) {
		glBegin(GL_QUADS);
		glColor3f(0.2f, 0.2f, 0.2f);
		glVertex2i(0, 0);
		glVertex2i(self->width, 0);
		glVertex2i(self->width, BUTTON_HEIGHT);
		glVertex2i(0, BUTTON_HEIGHT);
		glEnd();
	}
	
	glBegin(GL_LINE_LOOP);
	if (selected) {
		glColor3f(1.0f, 1.0f, 0.75f);
	} else {
		glColor3f(1.0f, 1.0f, 1.0f);
	}
	glVertex2i(0, 0);
	glVertex2i(self->width, 0);
	glVertex2i(self->width, BUTTON_HEIGHT);
	glVertex2i(0, BUTTON_HEIGHT);
	glEnd();
	
	glGetIntegerv(GL_VIEWPORT, viewport);
	glColor3f(1.0f, 1.0f, 1.0f);
	drawGlutString(3, 3, self->label);
	
	glPopMatrix();
}
